/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.markers;

import java.util.Date;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.sonarlint.eclipse.core.internal.PreferencesUtils;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;

public class SonarMarker {
    private SonarMarker() {
    }

    public static IMarker create(IDocument iDoc, IResource resource, Issue issue) throws CoreException {
        IMarker marker = resource.createMarker("org.sonarlint.eclipse.core.sonarlintProblem");
        SonarMarker.updateAttributes(marker, issue, iDoc);
        marker.setAttribute("creationdate", (Object)String.valueOf(new Date().getTime()));
        return marker;
    }

    public static void updateAttributes(IMarker marker, Issue issue, IDocument iDoc) throws CoreException {
        Integer startLine = issue.getStartLine();
        marker.setAttribute("priority", (Object)SonarMarker.getPriority(issue.getSeverity()));
        marker.setAttribute("severity", PreferencesUtils.getMarkerSeverity());
        marker.setAttribute("lineNumber", startLine != null ? startLine : 1);
        marker.setAttribute("message", (Object)SonarMarker.getMessage(issue));
        marker.setAttribute("rulekey", (Object)issue.getRuleKey());
        marker.setAttribute("rulename", (Object)issue.getRuleName());
        marker.setAttribute("sonarseverity", (Object)issue.getSeverity());
        if (iDoc != null && startLine != null) {
            try {
                SonarMarker.updateLocationAndChecksum(marker, issue, iDoc);
            }
            catch (BadLocationException e) {
                SonarLintCorePlugin.getDefault().error("Error while updating markers", e);
            }
        } else {
            marker.setAttribute("charStart", null);
            marker.setAttribute("charEnd", null);
            marker.setAttribute("checksum", null);
        }
    }

    private static void updateLocationAndChecksum(IMarker marker, Issue issue, IDocument iDoc) throws BadLocationException, CoreException {
        Range range = SonarMarker.findRangeInFile(issue, iDoc);
        marker.setAttribute("charStart", range.getStartOffset());
        marker.setAttribute("charEnd", range.getEndOffset());
        marker.setAttribute("checksum", SonarMarker.checksum(range.getContent()));
    }

    public static Range findRangeInFile(Issue issue, IDocument iDoc) throws BadLocationException {
        int end;
        int start;
        Integer startLine = issue.getStartLine();
        int startLineStartOffset = iDoc.getLineOffset(startLine - 1);
        Integer issueStartLineOffset = issue.getStartLineOffset();
        if (issueStartLineOffset != null) {
            start = startLineStartOffset + issueStartLineOffset;
            Integer issueEndLine = issue.getEndLine();
            int endLineStartOffset = issueEndLine.intValue() != startLine.intValue() ? iDoc.getLineOffset(issueEndLine - 1) : startLineStartOffset;
            end = endLineStartOffset + issue.getEndLineOffset();
        } else {
            start = startLineStartOffset;
            int length = iDoc.getLineLength(startLine - 1);
            String lineDelimiter = iDoc.getLineDelimiter(startLine - 1);
            int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
            end = startLineStartOffset + length - lineDelimiterLength;
        }
        String content = iDoc.get(start, end - start);
        return new Range(start, end, content);
    }

    public static String getMessage(Issue issue) {
        return issue.getMessage();
    }

    private static Integer getPriority(String severity) {
        int result = 0;
        if ("blocker".equalsIgnoreCase(severity) || "critical".equalsIgnoreCase(severity)) {
            result = 2;
        } else if ("major".equalsIgnoreCase(severity)) {
            result = 1;
        } else if ("minor".equalsIgnoreCase(severity) || "info".equalsIgnoreCase(severity)) {
            result = 0;
        }
        return result;
    }

    public static int checksum(String content) {
        return content.replaceAll("[\\s]", "").hashCode();
    }

    public static class Range {
        private final int startOffset;
        private final int endOffset;
        private final String content;

        public Range(int startOffset, int endOffset, String content) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.content = content;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String getContent() {
            return this.content;
        }
    }
}

